/*
 * Decompiled with CFR 0.152.
 */
package com.kekie6.colorfulazaleas.registry;

import com.kekie6.colorfulazaleas.blocks.ColorfulAzaleaBushBlock;
import com.kekie6.colorfulazaleas.blocks.DroopingLeavesBlock;
import com.kekie6.colorfulazaleas.platform.Services;
import com.kekie6.colorfulazaleas.registry.RegistrationProvider;
import com.kekie6.colorfulazaleas.registry.RegistryObject;
import com.kekie6.colorfulazaleas.util.ColorfulAzaleaTreeGrower;
import com.kekie6.colorfulazaleas.util.ColorfulTreeDecorator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WoodButtonBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FancyFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.AttachedToLeavesDecorator;
import net.minecraft.world.level.levelgen.feature.trunkplacers.FancyTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.material.Material;

public class AzaleaBlocks {
    public static final RegistrationProvider<Block> BLOCKS = RegistrationProvider.get(Registry.f_122824_, "colorfulazaleas");
    public static final RegistrationProvider<Item> ITEMS = RegistrationProvider.get(Registry.f_122827_, "colorfulazaleas");
    public static final RegistrationProvider<ConfiguredFeature<?, ?>> CONFIGURED_FEATURES = RegistrationProvider.get(BuiltinRegistries.f_123861_, "colorfulazaleas");
    public static ColorfulTree[] trees;
    public static final RegistryObject<Block> DROOPING_AZALEA_LEAVES;

    public static void init() {
        trees = new ColorfulTree[AzaleaColors.values().length];
        for (int i = 0; i < AzaleaColors.values().length; ++i) {
            AzaleaBlocks.trees[i] = new ColorfulTree(AzaleaColors.values()[i]);
        }
    }

    public static RegistryObject<Block> registerBlock(String name, Supplier<Block> block) {
        RegistryObject<Block> registryObject = BLOCKS.register(name, block);
        ITEMS.register(name, () -> new BlockItem((Block)registryObject.get(), new Item.Properties().m_41491_(Services.PLATFORM.getCreativeTab())));
        return registryObject;
    }

    static {
        DROOPING_AZALEA_LEAVES = AzaleaBlocks.registerBlock("drooping_azalea_leaves", () -> new DroopingLeavesBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76274_).m_60910_().m_60918_(SoundType.f_154664_)));
    }

    public static enum AzaleaColors {
        orange("tecal"),
        yellow("fiss"),
        red("roze"),
        blue("azule"),
        pink("bright"),
        purple("walnut"),
        white("titanium");

        final String title;

        private AzaleaColors(String title) {
            this.title = title;
        }
    }

    public static class ColorfulTree {
        public final String name;
        public final WoodType woodType;
        public final RegistryObject<Block> sapling;
        public final RegistryObject<Block> azaleaLeaves;
        public final RegistryObject<Block> floweringLeaves;
        public final RegistryObject<Block> bloomingLeaves;
        public final RegistryObject<Block> droopingLeaves;
        public final RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> feature;

        public ColorfulTree(AzaleaColors color) {
            this.name = color.name();
            this.woodType = new WoodType(color);
            this.azaleaLeaves = AzaleaBlocks.registerBlock(this.name + "_azalea_leaves", () -> new LeavesBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152470_)));
            this.floweringLeaves = AzaleaBlocks.registerBlock(this.name + "_flowering_azalea_leaves", () -> new LeavesBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152470_)));
            this.bloomingLeaves = AzaleaBlocks.registerBlock(this.name + "_blooming_azalea_leaves", () -> new LeavesBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152470_).m_60999_()));
            this.droopingLeaves = AzaleaBlocks.registerBlock(this.name + "_drooping_azalea_leaves", () -> new DroopingLeavesBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76274_).m_60910_().m_60918_(SoundType.f_154664_)));
            this.feature = ColorfulTree.registerAzaleaFeature(this.name + "_azalea_tree", () -> new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)this.woodType.log.get()), (TrunkPlacer)new FancyTrunkPlacer(8, 4, 6), (BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)Blocks.f_152470_.m_49966_(), 3).m_146271_((Object)this.floweringLeaves.get().m_49966_(), 1).m_146270_()), (FoliagePlacer)new FancyFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)3), (IntProvider)ConstantInt.m_146483_((int)3), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).m_161260_((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_152549_)).m_68249_(List.of(new AttachedToLeavesDecorator(1.0f, 0, 1, (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)this.bloomingLeaves.get().m_49966_()), 0, List.of(Direction.DOWN)), new ColorfulTreeDecorator(this.droopingLeaves.get(), this.woodType.log.get()))).m_161262_().m_68251_()));
            this.sapling = AzaleaBlocks.registerBlock(this.name + "_azalea_sapling", () -> new ColorfulAzaleaBushBlock(new ColorfulAzaleaTreeGrower(this.feature), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152541_).m_60955_()));
            Services.PLATFORM.addBlockToAzaleaLootTable(this.sapling);
        }

        private static RegistryObject<ConfiguredFeature<TreeConfiguration, ?>> registerAzaleaFeature(String name, Supplier<ConfiguredFeature<TreeConfiguration, ?>> configuredFeature) {
            return CONFIGURED_FEATURES.register(name, configuredFeature);
        }
    }

    public static class WoodType {
        public final String name;
        public final RegistryObject<Block> log;
        public final RegistryObject<Block> wood;
        public final RegistryObject<Block> stripped_log;
        public final RegistryObject<Block> stripped_wood;
        public final RegistryObject<Block> planks;
        public final RegistryObject<Block> stair;
        public final RegistryObject<Block> slab;
        public final RegistryObject<Block> door;
        public final RegistryObject<Block> trapdoor;
        public final RegistryObject<Block> fence;
        public final RegistryObject<Block> fence_gate;
        public final RegistryObject<Block> pressure_plate;
        public final RegistryObject<Block> button;

        public WoodType(AzaleaColors color) {
            this.name = color.title;
            this.log = AzaleaBlocks.registerBlock(this.name + "_azalea_log", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49999_)));
            this.wood = AzaleaBlocks.registerBlock(this.name + "_azalea_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50011_)));
            this.stripped_log = AzaleaBlocks.registerBlock("stripped_" + this.name + "_azalea_log", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50010_)));
            this.stripped_wood = AzaleaBlocks.registerBlock("stripped_" + this.name + "_azalea_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50044_)));
            this.planks = AzaleaBlocks.registerBlock(this.name + "_azalea_planks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
            this.stair = AzaleaBlocks.registerBlock(this.name + "_azalea_stairs", () -> new StairBlock(this.planks.get().m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)this.planks.get()))));
            this.slab = AzaleaBlocks.registerBlock(this.name + "_azalea_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_)));
            this.door = AzaleaBlocks.registerBlock(this.name + "_azalea_door", () -> new DoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50154_)));
            this.trapdoor = AzaleaBlocks.registerBlock(this.name + "_azalea_trapdoor", () -> new TrapDoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50216_)));
            this.fence = AzaleaBlocks.registerBlock(this.name + "_azalea_fence", () -> new FenceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50132_)));
            this.fence_gate = AzaleaBlocks.registerBlock(this.name + "_azalea_fence_gate", () -> new FenceGateBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50192_)));
            this.pressure_plate = AzaleaBlocks.registerBlock(this.name + "_azalea_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50167_)));
            this.button = AzaleaBlocks.registerBlock(this.name + "_azalea_button", () -> new WoodButtonBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50251_)));
        }
    }
}

